<?php

require_once('config.php');

check_user();

check_activation(true);

$page = 'schedule';

require_once('classes/user.php');
require_once('classes/fb.php');
require_once('classes/schedules.php');

$user_class = new User();

$user = $user_class->get_user();

$schedule_class = new Schedules($user);

$current_timestamp = $user_class->timestamp();

$fb = new Facebook();

$fb_user = $fb->get_fb_user();

$datefrom = '';
$dateinto = '';

$_SESSION['schedule_page'] = null;

if(isset($_POST['submit']) && $_POST['submit'] == 'filter'){
    if(isset($_POST['radio_queue']) && $_POST['radio_queue'] == '1'){
        $datefrom = empty($_POST['datefrom']) ? '' : $_POST['datefrom'];
        $dateinto = empty($_POST['dateinto']) ? '' : $_POST['dateinto'];
    }

    if(!empty($datefrom) && !empty($dateinto)){
        $schedules_data['filter_date']['date_from'] = $datefrom;
        $schedules_data['filter_date']['date_into'] = $dateinto;

        $datefrom = $schedule_class->unix_time($datefrom,'00:00');
        $dateinto = $schedule_class->unix_time($dateinto,'23:59');
    }
}

$_SESSION['schedule_page']['dates'] = array('datefrom' => $datefrom, 'dateinto' => $dateinto);

$schedules_data['schedules'] = $schedule_class->get_schedules_list2($datefrom, $dateinto);

$result_schedules = array();

if(!empty($schedules_data['schedules']))
    foreach($schedules_data['schedules'] as $schedule)
    {
        if(!empty($schedule['fan_pages']))
            foreach($schedule['fan_pages'] as $fan_page)
            {
                $result_schedules[$schedule['id']][$fan_page['id']] = array();
                if(!empty($fan_page['posts']))
                    foreach($fan_page['posts'] as $post)
                    {
                        $result_schedules[$schedule['id']][$fan_page['id']][] = $post['id'];
                    }
            }
    }

$_SESSION['schedule_page']['schedules'] = $result_schedules;


include('templates/schedules.php');